#include "completeloop.h"
#include "gameloop.h"
#include "NFont.h"

using namespace PL;
using namespace std;


extern NFont blackFont;

extern SDL_Surface* firePic1;
	

void showComplete(GameState* gs)
{
	CompleteState state;
	state.screen = gs->screen;
	switch(gs->levelNum)
	{
	    case 1:
            state.missionName = "Mission 1 Debriefing";
        break;
	    case 2:
            state.missionName = "Mission 2 Debriefing";
        break;
	    case 3:
            state.missionName = "Bonus Round Results";
        break;
	    case 4:
            state.missionName = "Mission 4 Debriefing";
        break;
	    case 5:
            state.missionName = "Mission 5 Debriefing";
        break;
	    case 6:
            state.missionName = "Mission 6 Debriefing";
        break;
	    case 7:
            state.missionName = "Mission 7 Debriefing";
        break;
	}
    
	
	float grassLeft = gs->burnMap->getSaved();
    gs->lostGrass = gs->savedGrass - grassLeft;
    gs->savedGrass = grassLeft;
	
	state.gameState = gs;
	
	CompleteUpdate update;
	
	CompleteDraw draw;
	
	CompleteEvent event;
	
	PL_Set set;
	set.update = &update;
	set.draw = &draw;
	set.any = &event;
	
	PL_Loop(&state, set);
	gs->dt = 0;
}

void CompleteUpdate::update(PL_State* state)
{
    CompleteState* s = static_cast<CompleteState*>(state);
	
    if(s->startDelay >= 0)
        s->startDelay -= s->dt;
	
}

void CompleteDraw::draw(PL_State* state)
{
    CompleteState* s = static_cast<CompleteState*>(state);
	
	SPG_RectRoundFilled(s->screen, 100, 100, 700, 500, 10, RGB_BLUEDK);
	
    blackFont.drawCenter(400, 150, "%s", s->missionName);
    
    
    float y = 200;
    if(s->gameState->bonus)
        blackFont.draw(200, y, "Trogdors:");
    else
        blackFont.draw(200, y, "Firefighters:");
    
    SPG_Draw(s->gameState->player->animRight.frame[0].pic, s->screen, 320, y - 20);
    if(s->gameState->player->hp <= 0)
    {
        SPG_Line(s->screen, 320, y - 20, 320 + 40, y - 20 + 40, RGB_RED);
    }
    
    y += 40;
    int i = 0;
    if(!s->gameState->bonus)
    {
        blackFont.draw(200, y, "Fires:");
        SDL_Surface* fire = SPG_Scale(firePic1, 0.3, 0.3);
        for(i = 0; i < s->gameState->startingFires; i++)
        {
            SPG_Draw(fire, s->screen, 270 + i*50, y - 20);
        }
        SDL_FreeSurface(fire);
        y += 40;
    }
    else
        y += 20;
    
    blackFont.draw(200, y, "Houses:");
    i = 0;
    float houseW = 300.0f/(s->gameState->lostHouses.size() + s->gameState->houses.size());
    for(list<House>::iterator e = s->gameState->lostHouses.begin(); e != s->gameState->lostHouses.end(); e++)
    {
        float x = 290 + i*houseW;
        SPG_Draw(e->pic, s->screen, x, y - 20);
        SPG_Line(s->screen, x, y - 20, x + 40, y - 20 + 40, RGB_RED);
        i++;
    }
    for(list<House>::iterator e = s->gameState->houses.begin(); e != s->gameState->houses.end(); e++)
    {
        SPG_Draw(e->pic, s->screen, 290 + i*houseW, y - 20);
        i++;
    }
    
    y += 40;
    blackFont.draw(200, y, "Grass: %.2f%%", 100*s->gameState->savedGrass/(s->gameState->savedGrass + s->gameState->lostGrass));
    
    
    
    if(s->startDelay < 0)
        blackFont.drawCenter(400, 400, "Click to continue");
	
	SDL_Flip(s->screen);
}

bool CompleteEvent::handleEvent(PL_State* state, SDL_Event& event)
{
    CompleteState* s = static_cast<CompleteState*>(state);
    
    if(event.type == SDL_MOUSEBUTTONDOWN)
    {
        if(event.button.button == SDL_BUTTON_LEFT)
        {
            if(s->startDelay < 0)
                s->done = true;
        }
    }
    
    return true;
}





